/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

public class ComputeLimits {
    static final ComputeLimits sm10ComputeLimits = new ComputeLimits(1, 0, 32, 24, 768, 8, 16384, 8192, 16384, 8192, 256, 128, true, 512, 2, 512);
    static final ComputeLimits sm11ComputeLimits = new ComputeLimits(1, 1, 32, 24, 768, 8, 16384, 8192, 16384, 8192, 256, 128, true, 512, 2, 512);
    static final ComputeLimits sm12ComputeLimits = new ComputeLimits(1, 2, 32, 32, 1024, 8, 16384, 16384, 16384, 16384, 512, 128, true, 512, 2, 512);
    static final ComputeLimits sm13ComputeLimits = new ComputeLimits(1, 3, 32, 32, 1024, 8, 16384, 16384, 16384, 16384, 512, 128, true, 512, 2, 512);
    static final ComputeLimits sm20ComputeLimits = new ComputeLimits(2, 0, 32, 48, 1536, 8, 49152, 32768, 49152, 32768, 64, 63, false, 128, 1, 1024);
    static final ComputeLimits sm21ComputeLimits = new ComputeLimits(2, 1, 32, 48, 1536, 8, 49152, 32768, 49152, 32768, 64, 63, false, 128, 1, 1024);
    static final ComputeLimits sm30ComputeLimits = new ComputeLimits(3, 0, 32, 64, 2048, 16, 49152, 65536, 49152, 65536, 256, 63, false, 128, 1, 1024);
    static final ComputeLimits sm32ComputeLimits = new ComputeLimits(3, 2, 32, 64, 2048, 16, 49152, 65536, 49152, 32768, 256, 255, false, 128, 1, 1024);
    static final ComputeLimits sm35ComputeLimits = new ComputeLimits(3, 5, 32, 64, 2048, 16, 49152, 65536, 49152, 65536, 256, 255, false, 128, 1, 1024);
    static final ComputeLimits sm37ComputeLimits = new ComputeLimits(3, 7, 32, 64, 2048, 16, 114688, 131072, 49152, 65536, 256, 255, false, 128, 1, 1024);
    static final ComputeLimits sm50ComputeLimits = new ComputeLimits(5, 0, 32, 64, 2048, 32, 65536, 65536, 49152, 65536, 256, 255, false, 256, 1, 1024);
    static final ComputeLimits sm52ComputeLimits = new ComputeLimits(5, 2, 32, 64, 2048, 32, 98304, 65536, 49152, 65536, 256, 255, false, 256, 1, 1024);
    static final ComputeLimits sm53ComputeLimits = new ComputeLimits(5, 3, 32, 64, 2048, 32, 98304, 65536, 49152, 32768, 256, 255, false, 256, 1, 1024);
    public final int computeMajor;
    public final int computeMinor;
    public final int threadsPerWarp;
    public final int warpsPerSM;
    public final int threadsPerSM;
    public final int blocksPerSM;
    public final int sharedMemPerBlock;
    public final int sharedMemPerSM;
    public final int regsPerBlock;
    public final int regsPerSM;
    public final int regAllocUnitSize;
    public final boolean regAllocGranularityBlock;
    public final int sharedMemAllocUnitSize;
    public final int warpAllocGranularity;
    public final int maxBlockSize;
    public final int maxRegsPerThread;

    private ComputeLimits(int computeMajor, int computeMinor, int threadsPerWarp, int warpsPerSM, int threadsPerSM, int blocksPerSM, int sharedMemPerSM, int regsPerSM, int sharedMemPerBlock, int regsPerBlock, int regAllocUnitSize, int maxRegsPerThread, boolean regAllocGranularityBlock, int sharedMemAllocUnitSize, int warpAllocGranulatiry, int maxBlockSize) {
        this.computeMajor = computeMajor;
        this.computeMinor = computeMinor;
        this.threadsPerWarp = threadsPerWarp;
        this.warpsPerSM = warpsPerSM;
        this.threadsPerSM = threadsPerSM;
        this.blocksPerSM = blocksPerSM;
        this.regsPerSM = regsPerSM;
        this.regAllocUnitSize = regAllocUnitSize;
        this.maxRegsPerThread = maxRegsPerThread;
        this.regAllocGranularityBlock = regAllocGranularityBlock;
        this.sharedMemPerSM = sharedMemPerSM;
        this.sharedMemAllocUnitSize = sharedMemAllocUnitSize;
        this.warpAllocGranularity = warpAllocGranulatiry;
        this.maxBlockSize = maxBlockSize;
        this.sharedMemPerBlock = sharedMemPerBlock;
        this.regsPerBlock = regsPerBlock;
    }

    public static ComputeLimits getComputeLimits(int major, int minor) {
        if (major == 1) {
            switch (minor) {
                case 0: {
                    return sm10ComputeLimits;
                }
                case 1: {
                    return sm11ComputeLimits;
                }
                case 2: {
                    return sm12ComputeLimits;
                }
                case 3: {
                    return sm13ComputeLimits;
                }
            }
        } else if (major == 2) {
            switch (minor) {
                case 0: {
                    return sm20ComputeLimits;
                }
                case 1: {
                    return sm21ComputeLimits;
                }
            }
        } else if (major == 3) {
            switch (minor) {
                case 0: {
                    return sm30ComputeLimits;
                }
                case 2: {
                    return sm32ComputeLimits;
                }
                case 5: {
                    return sm35ComputeLimits;
                }
                case 7: {
                    return sm37ComputeLimits;
                }
            }
        } else if (major == 5) {
            switch (minor) {
                case 0: {
                    return sm50ComputeLimits;
                }
                case 2: {
                    return sm52ComputeLimits;
                }
                case 3: {
                    return sm53ComputeLimits;
                }
            }
        }
        return null;
    }
}

