/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.expertsystem;

import com.nvidia.viper.ViewUtils;
import com.nvidia.viper.actions.ResetAnalysisAction;
import com.nvidia.viper.actions.RunAnalysisStageAction;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultNVLink;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.expertsystem.ExpertSystemStageKind;
import com.nvidia.viper.expertsystem.IExpertSystemStage;
import com.nvidia.viper.model.ExpertSystem;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.ui.NvprofMessageDialog;
import com.nvidia.viper.ui.analysis.AnalysisViewMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;

public class ExpertSystemStepAction {
    public static final ExpertSystemStepAction NONE = new ExpertSystemStepAction(Kind.NONE);
    public static final ExpertSystemStepAction CLEAR_RESULTS = new ExpertSystemStepAction(Kind.SHOW_RESULTS);
    private final Kind kind;
    private Object data;

    public ExpertSystemStepAction(Kind kind) {
        this.kind = kind;
        this.data = null;
    }

    public ExpertSystemStepAction(Kind kind, Object data) {
        this(kind);
        this.data = data;
    }

    public ExpertSystemStepAction(ExpertSystemStepAction ... actions) {
        this(Kind.COMPOUND, new ArrayList<ExpertSystemStepAction>(Arrays.asList(actions)));
    }

    public ExpertSystemStepAction(ExpertSystemStageKind stageKind) {
        this(Kind.CHANGE_STAGE, (Object)stageKind);
    }

    public ExpertSystemStepAction(boolean force, Set<AnalysisStage> analysisStages) {
        this(Kind.RUN_ANALYSIS, new RunAnalysisData(analysisStages, force));
    }

    public ExpertSystemStepAction(boolean force, AnalysisStage ... analysisStages) {
        this(Kind.RUN_ANALYSIS, new RunAnalysisData(new HashSet<AnalysisStage>(Arrays.asList(analysisStages)), force));
    }

    public ExpertSystemStepAction(AnalysisStage stage, Class<? extends AnalysisResult> analysisClass) {
        this(Kind.SHOW_RESULTS, Collections.singletonList(new ShowResultsData(stage, analysisClass)));
    }

    public ExpertSystemStepAction(AnalysisStage stage, Class<? extends AnalysisResult> analysisClass, AnalysisDescriptor descriptor) {
        this(Kind.SHOW_RESULTS, Collections.singletonList(new ShowResultsData(stage, analysisClass, descriptor)));
    }

    public ExpertSystemStepAction(ShowResultsData ... resultDatas) {
        this(Kind.SHOW_RESULTS, new ArrayList<ShowResultsData>(Arrays.asList(resultDatas)));
    }

    public ExpertSystemStepAction(List<ShowResultsData> resultDatas) {
        this(Kind.SHOW_RESULTS, resultDatas);
    }

    public Kind getKind() {
        return this.kind;
    }

    public Object getData() {
        return this.data;
    }

    public ExpertSystemStageKind getExpertSystemStageKind() {
        if (Kind.CHANGE_STAGE.equals((Object)this.kind) && this.data instanceof ExpertSystemStageKind) {
            return (ExpertSystemStageKind)((Object)this.data);
        }
        return null;
    }

    public Set<AnalysisStage> getAnalysisStages() {
        if (Kind.RUN_ANALYSIS.equals((Object)this.kind) && this.data instanceof RunAnalysisData) {
            RunAnalysisData rad = (RunAnalysisData)this.data;
            return rad.analysisStages;
        }
        return null;
    }

    public Boolean getAnalysisForce() {
        if (Kind.RUN_ANALYSIS.equals((Object)this.kind) && this.data instanceof RunAnalysisData) {
            RunAnalysisData rad = (RunAnalysisData)this.data;
            return rad.force;
        }
        return null;
    }

    public List<ShowResultsData> getShowResults() {
        if (Kind.SHOW_RESULTS.equals((Object)this.kind) && this.data instanceof List) {
            return (List)this.data;
        }
        return null;
    }

    public IStatus perform(Session session) {
        IStatus status = Status.OK_STATUS;
        ExpertSystem expertSystem = session.getExpertSystem();
        if (expertSystem != null) {
            block0 : switch (this.kind) {
                case NONE: {
                    break;
                }
                case COMPOUND: {
                    List actions = (List)this.data;
                    for (ExpertSystemStepAction action : actions) {
                        status = action.perform(session);
                        if (!Status.OK_STATUS.equals(status) && !Status.CANCEL_STATUS.equals(status)) break block0;
                    }
                    break;
                }
                case CHANGE_STAGE: {
                    ExpertSystemStageKind currentKind = expertSystem.getCurrentStageKind();
                    ExpertSystemStageKind newCurrentKind = this.getExpertSystemStageKind();
                    if (currentKind.equals((Object)newCurrentKind)) break;
                    IExpertSystemStage newCurrentStage = expertSystem.getStageForKind(newCurrentKind);
                    ExpertSystemStepAction actions = newCurrentStage.update();
                    status = actions.perform(session);
                    expertSystem.setCurrentStageKind(newCurrentKind);
                    break;
                }
                case SET_UNGUIDED_MODE: {
                    if (session == null || session.getAnalysis() == null) break;
                    session.getAnalysis().setCurrentAnalysisMode(AnalysisViewMode.unguided);
                    break;
                }
                case SET_GUIDED_MODE: {
                    if (session == null || session.getAnalysis() == null) break;
                    session.getAnalysis().setCurrentAnalysisMode(AnalysisViewMode.guided);
                    break;
                }
                case RESET_ANALYSIS: {
                    if (session == null) break;
                    new ResetAnalysisAction(session, false).run();
                    break;
                }
                case RUN_ANALYSIS: {
                    status = this.runAnalysisAndWait(session);
                    break;
                }
                case SHOW_RESULTS: {
                    if (session == null || session.getAnalysis() == null) break;
                    List<ShowResultsData> showResults = this.getShowResults();
                    LinkedList<AnalysisResult> results = new LinkedList<AnalysisResult>();
                    if (showResults != null) {
                        for (ShowResultsData data : showResults) {
                            LinkedList<AnalysisResult> trs = new LinkedList<AnalysisResult>();
                            if (data.getAnalysisClass() == null) {
                                trs.addAll(session.getAnalysis().getAnalysisResults(data.getStage()));
                            } else {
                                trs.addAll(session.getAnalysis().getAnalysisResults(data.getStage(), data.getAnalysisClass()));
                            }
                            for (AnalysisResult result : trs) {
                                if (AnalysisDescriptor.Severity.OK.equals((Object)result.getSeverity()) || data.getDescriptor() != null && !data.getDescriptor().equals((Object)result.getDescriptor())) continue;
                                if (result instanceof AnalysisResultNVLink) {
                                    if (!AnalysisDescriptor.Severity.INFO.equals((Object)result.getSeverity())) continue;
                                    results.add(result);
                                    continue;
                                }
                                results.add(result);
                            }
                        }
                    }
                    expertSystem.setAnalysisResults(results);
                    break;
                }
                default: {
                    status = new Status(4, "com.nvidia.viper", "unknown action, can't perform");
                }
            }
        }
        return status;
    }

    public void flatten(boolean mergeRunAnalysis) {
        if (Kind.COMPOUND.equals((Object)this.kind) && this.data != null) {
            List<ExpertSystemStepAction> flattenedActions = this.flattenRecurse();
            if (mergeRunAnalysis) {
                LinkedList<ExpertSystemStepAction> mergedActions = new LinkedList<ExpertSystemStepAction>();
                RunAnalysisData lastRunAnalysisData = null;
                for (ExpertSystemStepAction action : flattenedActions) {
                    if (Kind.RUN_ANALYSIS.equals((Object)action.kind)) {
                        if (lastRunAnalysisData == null) {
                            lastRunAnalysisData = new RunAnalysisData();
                        }
                        lastRunAnalysisData.analysisStages.addAll(action.getAnalysisStages());
                        RunAnalysisData runAnalysisData = lastRunAnalysisData;
                        runAnalysisData.force = runAnalysisData.force | action.getAnalysisForce();
                        continue;
                    }
                    if (lastRunAnalysisData != null) {
                        mergedActions.add(new ExpertSystemStepAction(lastRunAnalysisData.force, lastRunAnalysisData.analysisStages));
                    }
                    mergedActions.add(action);
                }
                if (lastRunAnalysisData != null) {
                    mergedActions.add(new ExpertSystemStepAction(lastRunAnalysisData.force, lastRunAnalysisData.analysisStages));
                }
                flattenedActions = mergedActions;
            }
            this.data = flattenedActions;
        }
    }

    private List<ExpertSystemStepAction> flattenRecurse() {
        if (!Kind.COMPOUND.equals((Object)this.kind)) {
            return Collections.singletonList(this);
        }
        LinkedList<ExpertSystemStepAction> flattenedActions = new LinkedList<ExpertSystemStepAction>();
        List actions = (List)this.data;
        for (ExpertSystemStepAction action : actions) {
            flattenedActions.addAll(action.flattenRecurse());
        }
        return flattenedActions;
    }

    private IStatus runAnalysisAndWait(Session session) {
        Set<AnalysisStage> stages = this.getAnalysisStages();
        boolean force = this.getAnalysisForce();
        RunAnalysisStageAction.DataCollection dataCollect = session.getExecutable() == null ? RunAnalysisStageAction.DataCollection.NONE : (force ? RunAnalysisStageAction.DataCollection.FORCE : RunAnalysisStageAction.DataCollection.IFNEEDED);
        final IStatus[] analysisStatus = new IStatus[]{Status.OK_STATUS};
        final boolean[] analysisDone = new boolean[1];
        RunAnalysisStageAction analysisAction = new RunAnalysisStageAction(session, stages.toArray(new AnalysisStage[0]), dataCollect){

            @Override
            public void analysisCompleted(IStatus status) {
                analysisStatus[0] = status;
                analysisDone[0] = true;
            }
        };
        analysisAction.run();
        while (!analysisDone[0]) {
            Display.getDefault().readAndDispatch();
        }
        if (!NvprofMessageDialog.openWarning(session)) {
            ViewUtils.showAnalysisView();
        }
        return analysisStatus[0];
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExpertSystemStepAction) {
            ExpertSystemStepAction other = (ExpertSystemStepAction)obj;
            if (this.kind == null || other == null) {
                return other != null && other.kind == null;
            }
            if (!this.kind.equals((Object)other.kind)) {
                return false;
            }
            return this.data == other.data || this.data != null && this.data.equals(other.data);
        }
        return false;
    }

    public String toString() {
        return "[ExpertSystemStepAction " + (Object)((Object)this.kind) + ": " + (this.data == null ? "<no data>" : this.data);
    }

    public static enum Kind {
        NONE,
        COMPOUND,
        SET_UNGUIDED_MODE,
        SET_GUIDED_MODE,
        CHANGE_STAGE,
        SHOW_RESULTS,
        RESET_ANALYSIS,
        RUN_ANALYSIS;

    }

    private static class RunAnalysisData {
        private final Set<AnalysisStage> analysisStages;
        private boolean force;

        private RunAnalysisData(Set<AnalysisStage> analysisStages, boolean force) {
            this.analysisStages = analysisStages;
            this.force = force;
        }

        public RunAnalysisData() {
            this(new HashSet<AnalysisStage>(), false);
        }

        public boolean equals(Object obj) {
            if (obj instanceof RunAnalysisData) {
                RunAnalysisData other = (RunAnalysisData)obj;
                return this.analysisStages.equals(other.analysisStages) && this.force == other.force;
            }
            return false;
        }

        public String toString() {
            return "<RunAnalysisData: force=" + this.force + ", " + this.analysisStages + ">";
        }
    }

    public static class ShowResultsData {
        private final AnalysisStage stage;
        private final Class<? extends AnalysisResult> analysisClass;
        private final AnalysisDescriptor descriptor;

        public ShowResultsData(AnalysisStage stage, Class<? extends AnalysisResult> analysisClass) {
            this(stage, analysisClass, null);
        }

        public ShowResultsData(AnalysisStage stage, Class<? extends AnalysisResult> analysisClass, AnalysisDescriptor descriptor) {
            this.stage = stage;
            this.analysisClass = analysisClass;
            this.descriptor = descriptor;
        }

        public AnalysisStage getStage() {
            return this.stage;
        }

        public Class<? extends AnalysisResult> getAnalysisClass() {
            return this.analysisClass;
        }

        public AnalysisDescriptor getDescriptor() {
            return this.descriptor;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ShowResultsData) {
                ShowResultsData other = (ShowResultsData)obj;
                return this.stage == other.stage && this.analysisClass == other.analysisClass && this.descriptor == other.descriptor;
            }
            return false;
        }

        public int hashCode() {
            return this.stage.hashCode() + this.analysisClass.hashCode() + (this.descriptor == null ? 0 : this.descriptor.hashCode());
        }

        public String toString() {
            return "<ShowResultsData: " + (Object)((Object)this.stage) + ", " + this.analysisClass + ", " + (Object)((Object)this.descriptor) + ">";
        }
    }
}

