/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.expertsystem;

import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultDivergentBranch;
import com.nvidia.viper.analysis.AnalysisResultInstructionExecution;
import com.nvidia.viper.analysis.AnalysisResultIntervalNoData;
import com.nvidia.viper.analysis.AnalysisResultKernelBounds;
import com.nvidia.viper.analysis.AnalysisResultKernelExecutionEfficiency;
import com.nvidia.viper.analysis.AnalysisResultKernelFlops;
import com.nvidia.viper.analysis.AnalysisResultKernelInstructionClass;
import com.nvidia.viper.analysis.AnalysisResultKernelUnitBusy;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.analysis.ResultOutput;
import com.nvidia.viper.expertsystem.ExpertSystemStageKind;
import com.nvidia.viper.expertsystem.ExpertSystemStepAction;
import com.nvidia.viper.expertsystem.IExpertSystemStage;
import com.nvidia.viper.expertsystem.KernelInstanceStage;
import com.nvidia.viper.jni.CuptiMetricValueUtilizationLevel;
import com.nvidia.viper.model.ExpertSystem;
import com.nvidia.viper.model.ITimelineInterval;
import java.util.LinkedList;

public class ComputeStage
extends KernelInstanceStage
implements IExpertSystemStage {
    public ComputeStage(ExpertSystem expertSystem) {
        super(expertSystem);
    }

    @Override
    public ExpertSystemStageKind getStageKind() {
        return ExpertSystemStageKind.COMPUTE;
    }

    @Override
    public String getTitle(ResultOutput otpt) {
        return ViperMessages.ExpertSystem_Compute_Title;
    }

    public static ExpertSystemStepAction getAnalysisRunAction(boolean force) {
        return new ExpertSystemStepAction(new ExpertSystemStepAction(force, AnalysisStage.KERNEL_INSTANCE_SM, AnalysisStage.KERNEL_INSTANCE_DIVERGENT_BRANCH));
    }

    @Override
    public ExpertSystemStepAction update() {
        this.stageDesc = ViperMessages.ExpertSystem_Compute_Desc;
        this.numSteps = 0;
        this.stepTitles = null;
        this.stepDescs = null;
        this.stepActions = null;
        ExpertSystemStepAction updateAction = ExpertSystemStepAction.NONE;
        ITimelineInterval kernel = this.getSelectedInDepthKernel();
        AnalysisResultIntervalNoData failResult = this.getFailResult();
        AnalysisResultKernelBounds boundsResult = this.getBoundsResult();
        AnalysisResultKernelUnitBusy busyResult = this.getBusyResult();
        AnalysisResultKernelInstructionClass icResult = this.getInstructionClassResult();
        AnalysisResultKernelFlops flopsResult = this.getFlopsResult();
        AnalysisResultKernelExecutionEfficiency execEffResult = this.getExecutionEfficiencyResult();
        AnalysisResultDivergentBranch divergentResult = this.getDivergentBranchResult();
        AnalysisResultInstructionExecution instExecResult = this.getInstructionExecutionResult();
        AnalysisResult divergentNoSourceResult = this.getDivergentBranchNoSourceResult();
        AnalysisResult instExecNoSourceResult = this.getInstructionExecutionNoSourceResult();
        if (busyResult != null && boundsResult != null && (AnalysisResultKernelBounds.Bound.BALANCED_COMPUTE_MEMORY.equals((Object)boundsResult.getBound()) || AnalysisResultKernelBounds.Bound.COMPUTE.equals((Object)boundsResult.getBound()))) {
            CuptiMetricValueUtilizationLevel maxBusy = busyResult.getFunctionUnitMaxBusy();
            if (!boundsResult.isIssueSlotBound() || maxBusy.getCode() >= CuptiMetricValueUtilizationLevel.CUPTI_METRIC_VALUE_UTILIZATION_9.getCode()) {
                busyResult.SetIsPerformanceLimiter(true);
            }
        }
        if (kernel == null) {
            this.stageDesc = String.valueOf(this.stageDesc) + " " + ViperMessages.ExpertSystem_DescNoKernel;
            updateAction = ExpertSystemStepAction.CLEAR_RESULTS;
        } else if (failResult != null && busyResult == null && icResult == null && flopsResult == null) {
            this.stageDesc = String.valueOf(this.stageDesc) + " " + ViperMessages.ExpertSystem_DescFailResult;
            this.numSteps = 0;
            this.stepTitles = null;
            this.stepDescs = null;
            this.stepActions = null;
            updateAction = new ExpertSystemStepAction(AnalysisStage.KERNEL_INSTANCE_SM, AnalysisResultIntervalNoData.class);
        } else if (busyResult == null && icResult == null && flopsResult == null) {
            this.stageDesc = String.valueOf(this.stageDesc) + " " + ViperMessages.ExpertSystem_DescNoResult;
            this.numSteps = 1;
            this.stepTitles = new String[]{ViperMessages.ExpertSystem_StepNoResult_Title};
            this.stepDescs = new String[]{ViperMessages.ExpertSystem_StepNoResult_Desc};
            this.stepActions = new ExpertSystemStepAction[]{KernelInstanceStage.getAnalysisRunAction(false)};
            updateAction = ExpertSystemStepAction.CLEAR_RESULTS;
        } else {
            int n = this.numSteps = instExecResult == null ? 2 : 1;
            if (this.numSteps == 1) {
                this.stepTitles = new String[]{ViperMessages.ExpertSystem_StepRerun_Title};
                this.stepDescs = new String[]{ViperMessages.ExpertSystem_StepRerun_Desc};
                this.stepActions = new ExpertSystemStepAction[]{KernelInstanceStage.getAnalysisRunAction(true)};
            } else {
                this.stepTitles = new String[]{ViperMessages.ExpertSystem_Compute_ShowInstructionExecution_Title, ViperMessages.ExpertSystem_StepRerun_Title};
                this.stepDescs = new String[]{ViperMessages.ExpertSystem_Compute_ShowInstructionExecution_Desc, ViperMessages.ExpertSystem_StepRerun_Desc};
                this.stepActions = new ExpertSystemStepAction[]{new ExpertSystemStepAction(false, AnalysisStage.KERNEL_INSTANCE_INSTRUCTION_EXECUTION), KernelInstanceStage.getAnalysisRunAction(true)};
            }
            LinkedList<ExpertSystemStepAction.ShowResultsData> showResults = new LinkedList<ExpertSystemStepAction.ShowResultsData>();
            if (instExecNoSourceResult != null || divergentNoSourceResult != null) {
                if (divergentNoSourceResult != null) {
                    showResults.add(new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNEL_INSTANCE_DIVERGENT_BRANCH, AnalysisResult.class, AnalysisDescriptor.SL_DIVERGENTBRANCH_NO_SOURCE));
                } else {
                    showResults.add(new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNEL_INSTANCE_INSTRUCTION_EXECUTION, AnalysisResult.class, AnalysisDescriptor.SL_INSTRUCTION_EXECUTION_NO_SOURCE));
                }
            }
            showResults.add(new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNEL_INSTANCE_INSTRUCTION_EXECUTION, AnalysisResultInstructionExecution.class));
            boolean noProblem = true;
            if (execEffResult != null || divergentResult != null) {
                noProblem = false;
                this.stageDesc = String.valueOf(this.stageDesc) + " " + ViperMessages.ExpertSystem_Compute_DescExecEfficiency;
                if (execEffResult != null) {
                    showResults.add(new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNEL_INSTANCE_SM, AnalysisResultKernelExecutionEfficiency.class));
                }
                if (divergentResult != null) {
                    showResults.add(new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNEL_INSTANCE_DIVERGENT_BRANCH, AnalysisResultDivergentBranch.class));
                }
            }
            if (busyResult != null) {
                noProblem = false;
                if (AnalysisDescriptor.KERNEL_COMPUTE_PIPE_BUSY_LIMITER.equals((Object)busyResult.getDescriptor())) {
                    this.stageDesc = String.valueOf(this.stageDesc) + " " + ViperMessages.ExpertSystem_Compute_DescFunctionUnitUsage;
                }
                showResults.add(new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNEL_INSTANCE_SM, AnalysisResultKernelUnitBusy.class));
            }
            if (icResult != null) {
                showResults.add(new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNEL_INSTANCE_SM, AnalysisResultKernelInstructionClass.class));
            }
            if (flopsResult != null) {
                showResults.add(new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNEL_INSTANCE_SM, AnalysisResultKernelFlops.class));
            }
            if (noProblem) {
                this.stageDesc = String.valueOf(this.stageDesc) + " " + ViperMessages.ExpertSystem_Compute_DescGood;
            }
            updateAction = new ExpertSystemStepAction(showResults.toArray(new ExpertSystemStepAction.ShowResultsData[0]));
        }
        return updateAction;
    }

    private AnalysisResultIntervalNoData getFailResult() {
        return (AnalysisResultIntervalNoData)this.getKernelResult(AnalysisStage.KERNEL_INSTANCE_SM, AnalysisResultIntervalNoData.class);
    }

    private AnalysisResultKernelBounds getBoundsResult() {
        return (AnalysisResultKernelBounds)this.getKernelResult(AnalysisStage.KERNEL_INSTANCE_BOUNDS, AnalysisResultKernelBounds.class);
    }

    private AnalysisResultKernelUnitBusy getBusyResult() {
        return (AnalysisResultKernelUnitBusy)this.getKernelResult(AnalysisStage.KERNEL_INSTANCE_SM, AnalysisResultKernelUnitBusy.class);
    }

    private AnalysisResultKernelInstructionClass getInstructionClassResult() {
        return (AnalysisResultKernelInstructionClass)this.getKernelResult(AnalysisStage.KERNEL_INSTANCE_SM, AnalysisResultKernelInstructionClass.class);
    }

    private AnalysisResultKernelFlops getFlopsResult() {
        return (AnalysisResultKernelFlops)this.getKernelResult(AnalysisStage.KERNEL_INSTANCE_SM, AnalysisResultKernelFlops.class);
    }

    private AnalysisResultKernelExecutionEfficiency getExecutionEfficiencyResult() {
        return (AnalysisResultKernelExecutionEfficiency)this.getKernelResult(AnalysisStage.KERNEL_INSTANCE_SM, AnalysisResultKernelExecutionEfficiency.class);
    }

    private AnalysisResultDivergentBranch getDivergentBranchResult() {
        return (AnalysisResultDivergentBranch)this.getKernelResult(AnalysisStage.KERNEL_INSTANCE_DIVERGENT_BRANCH, AnalysisResultDivergentBranch.class);
    }

    private AnalysisResultInstructionExecution getInstructionExecutionResult() {
        return (AnalysisResultInstructionExecution)this.getKernelResult(AnalysisStage.KERNEL_INSTANCE_INSTRUCTION_EXECUTION, AnalysisResultInstructionExecution.class);
    }

    private AnalysisResult getDivergentBranchNoSourceResult() {
        return this.getKernelResult(AnalysisStage.KERNEL_INSTANCE_DIVERGENT_BRANCH, AnalysisResult.class, AnalysisDescriptor.SL_DIVERGENTBRANCH_NO_SOURCE);
    }

    private AnalysisResult getInstructionExecutionNoSourceResult() {
        return this.getKernelResult(AnalysisStage.KERNEL_INSTANCE_INSTRUCTION_EXECUTION, AnalysisResult.class, AnalysisDescriptor.SL_INSTRUCTION_EXECUTION_NO_SOURCE);
    }
}

