/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.editor;

import com.nvidia.viper.editor.AbstractViewerColumnsManager;
import com.nvidia.viper.editor.GPRColumn;
import com.nvidia.viper.editor.IViewerColumnsManager;
import com.nvidia.viper.editor.SourceSassColumnControl;
import com.nvidia.viper.editor.ViewerControl;
import com.nvidia.viper.model.SourceSassModel;
import com.nvidia.viper.ui.CudaViewer;
import com.nvidia.viper.ui.SassViewer;
import com.nvidia.viper.ui.ViperViewerBase;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Label;

public class GPRAccessManager
extends AbstractViewerColumnsManager
implements IViewerColumnsManager {
    @Override
    public void setEnableColumns(SourceSassColumnControl control, boolean enable) {
        Label label = control.getLabel("Registers");
        if (label != null) {
            label.setVisible(enable);
            GridData gridData = (GridData)label.getLayoutData();
            boolean bl = gridData.exclude = !enable;
            if (enable) {
                SourceSassModel sourceSassModel = this.getSourceSassModel(control);
                sourceSassModel.generateGPRInfo();
                GPRColumn localGPRColumn = new GPRColumn();
                this.addColumn(control, localGPRColumn, label, gridData);
            } else {
                control.removeColumn((IVerticalRulerColumn)this.column);
            }
            this.fireProperties(enable);
        }
    }

    private SourceSassModel getSourceSassModel(SourceSassColumnControl control) {
        ViewerControl viewerControl = control.getControl();
        if (viewerControl != null) {
            return viewerControl.getEditor().getSourceSassModel();
        }
        return null;
    }

    @Override
    public void addAnalysisColumns(SourceSassColumnControl control) {
        GridData gridData = new GridData(90, -1);
        Label label = control.addLabel("Registers", "", gridData);
        label.setVisible(false);
        gridData.exclude = true;
    }

    @Override
    public void createAnnotations(ViperViewerBase viewer, IAnnotationModel model) {
        if (viewer instanceof SassViewer) {
            ((SassViewer)viewer).createAnnotationsForGPR(model);
        }
    }

    @Override
    public void selectDefaultSourceLine(CudaViewer viewer) {
    }

    @Override
    public boolean isVisible(SourceSassColumnControl control) {
        return control.existsColumn(GPRColumn.class);
    }
}

