/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.activity.CuptiActivityPCSampling;
import com.nvidia.viper.activity.ICuptiActivitySourceLevelResult;
import com.nvidia.viper.analysis.AnalysisBase;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultPCSampling;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.CudaFunctionManager;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.TimelineIntervalKernel;
import java.util.List;

public class KernelInstancePCSamplingAnalysis
extends AnalysisBase {
    public static boolean isPCSamplingEnabledOnDevice(int computeCapability) {
        if (computeCapability == 62) {
            if (System.getenv("__CUDA_PM_INTERNAL") != null) {
                return System.getenv("__CUDA_PM_INTERNAL").equals("1");
            }
            return false;
        }
        return computeCapability >= 52 && computeCapability != 53;
    }

    @Override
    public boolean run(Session session, List<AnalysisResult> results, boolean generateAllResults) {
        boolean ret = false;
        if (CudaFunctionManager.getNvdisasmPath() == null) {
            results.add(new AnalysisResult(AnalysisDescriptor.SL_PC_SAMPLING_NO_DISASM));
            return false;
        }
        Analysis analysis = session.getAnalysis();
        if (analysis != null) {
            TimelineIntervalKernel interval = AnalysisStage.getHostLaunchedKernel(analysis.getActiveScopeInterval());
            if (interval == null || generateAllResults) {
                results.add(new AnalysisResult(AnalysisDescriptor.SL_PC_SAMPLING_NO_KERNEL));
            }
            if (interval instanceof TimelineIntervalKernel) {
                TimelineIntervalKernel kernel = interval;
                int totalResults = 0;
                int droppedResults = 0;
                AnalysisResultPCSampling dpa = new AnalysisResultPCSampling(session, kernel, AnalysisDescriptor.SL_PC_SAMPLING);
                for (ICuptiActivitySourceLevelResult result : kernel.getSourceLevelResults()) {
                    if (!(result instanceof CuptiActivityPCSampling)) continue;
                    ++totalResults;
                    ret = true;
                    if (dpa.addResult(result)) continue;
                    ++droppedResults;
                }
                if (dpa.getSourceLevelResultCount() > 0 || generateAllResults) {
                    results.add(dpa);
                }
                if (droppedResults > 0 || generateAllResults) {
                    AnalysisDescriptor desc = droppedResults == totalResults ? AnalysisDescriptor.SL_PC_SAMPLING_NO_SOURCE : AnalysisDescriptor.SL_PC_SAMPLING_FEW_SOURCE;
                    results.add(new AnalysisResult(desc));
                }
                if (totalResults <= 0 || generateAllResults) {
                    results.add(new AnalysisResult(AnalysisDescriptor.SL_PC_SAMPLING_NO_DATA));
                }
            }
        }
        return ret;
    }
}

