/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper;

import com.nvidia.common.util.NativeUtils;
import com.nvidia.common.util.OS;
import com.nvidia.viper.Activator;
import com.nvidia.viper.TemporaryDirs;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.activity.CuptiActivitySourceLocator;
import com.nvidia.viper.model.Session;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class FileUtils {
    static long DEFAULT_HEAP_SIZE = 910L;
    static long DEFAULT_ALLOWED_SIZE = 200L;

    public static void saveSession(File file, Session session) throws ViperException {
        try {
            FileOutputStream fout = new FileOutputStream(file);
            FileUtils.saveSession(fout, session);
        }
        catch (Exception e) {
            if (e instanceof ViperException) {
                throw (ViperException)e;
            }
            throw new ViperException(e);
        }
    }

    public static Session loadSession(File file) throws ViperException {
        try {
            DocumentBuilder docReader = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            docReader.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException arg0) throws SAXException {
                }

                @Override
                public void fatalError(SAXParseException arg0) throws SAXException {
                }

                @Override
                public void error(SAXParseException arg0) throws SAXException {
                }
            });
            Document doc = docReader.parse(file);
            Session session = new Session(doc.getDocumentElement());
            if (session != null) {
                session.waitForLoadTimelines();
            }
            session.setName(file.getName());
            session.setFile(file);
            return session;
        }
        catch (Exception e) {
            if (e instanceof ViperException) {
                throw (ViperException)e;
            }
            throw new ViperException(e);
        }
    }

    public static void rmDir(File dir) throws ViperException {
        if (!dir.isDirectory()) {
            throw new ViperException("cannot delete " + dir + ": not a directory");
        }
        FileUtils.rmDirWork(dir);
    }

    private static void rmDirWork(File dir) throws ViperException {
        if (dir.isDirectory()) {
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File c = fileArray[n2];
                FileUtils.rmDirWork(c);
                ++n2;
            }
        }
        if (!dir.delete()) {
            throw new ViperException("failed to delete file: " + dir);
        }
    }

    public static void saveSession(OutputStream os, Session session) throws ViperException {
        try {
            OutputStreamWriter osw = new OutputStreamWriter(os, "UTF-8");
            BufferedWriter bout = new BufferedWriter(osw);
            bout.write("<?xml version=\"1.0\"?>\n");
            session.write(bout);
            bout.flush();
        }
        catch (Exception e) {
            if (e instanceof ViperException) {
                throw (ViperException)e;
            }
            throw new ViperException(e);
        }
    }

    public static String resolveFilePathInBrowser(CuptiActivitySourceLocator sourceLocator, Session session) {
        if (sourceLocator != null) {
            File file = new File(sourceLocator.fileName);
            if (!file.isFile()) {
                HashMap<Object, URI> resolvedPaths = new HashMap<Object, URI>();
                resolvedPaths.put(sourceLocator, sourceLocator.getFileUri());
                Activator.getDefault().getViperWorkbench().resolvePathsInSession(session, resolvedPaths);
                URI resolvedPath = (URI)resolvedPaths.get(sourceLocator);
                if (resolvedPath == null) {
                    HashSet<URI> manualPaths = new HashSet<URI>();
                    manualPaths.add(sourceLocator.getFileUri());
                    Activator.getDefault().getViperWorkbench().updatePathsInSession(session, manualPaths, false);
                    resolvedPaths.put(sourceLocator, sourceLocator.getFileUri());
                    Activator.getDefault().getViperWorkbench().resolvePathsInSession(session, resolvedPaths);
                    resolvedPath = (URI)resolvedPaths.get(sourceLocator);
                }
                if (resolvedPath != null) {
                    return resolvedPath.getPath();
                }
                return null;
            }
            return sourceLocator.fileName;
        }
        return null;
    }

    public static File findExecutableOnPath(String baseName, String fileExt) {
        String[] paths;
        String ext = fileExt;
        if (fileExt.isEmpty()) {
            ext = NativeUtils.getExecutableExtension((OS)OS.local());
        }
        String exeName = String.valueOf(baseName) + ext;
        String pathenv = System.getenv("PATH");
        String[] stringArray = paths = pathenv.split(File.pathSeparator);
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            File file = new File(String.valueOf(path) + File.separator + exeName);
            if (file.isFile()) {
                return file;
            }
            ++n2;
        }
        return null;
    }

    public static boolean canLoad(File[] files) {
        long fileSize = 0L;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            fileSize += (long)((double)file.length() / 1048576.0);
            ++n2;
        }
        long allowed = FileUtils.maxAllowedSizeMB();
        return fileSize <= allowed;
    }

    public static long maxAllowedSizeMB() {
        long maxMemMb = FileUtils.maxHeapSizeMB();
        long allowed = (long)((double)maxMemMb / (double)DEFAULT_HEAP_SIZE * (double)DEFAULT_ALLOWED_SIZE);
        return allowed;
    }

    public static long maxHeapSizeMB() {
        long maxMemMb = Runtime.getRuntime().maxMemory() / 0x100000L;
        return maxMemMb;
    }

    public static String getIniFilePath() {
        try {
            URL url = new URL(Platform.getInstallLocation().getURL() + "nvvp.ini");
            if (url != null) {
                return url.getPath();
            }
        }
        catch (MalformedURLException e) {
            ViperExceptionHandler.logError(e.getMessage());
        }
        return null;
    }

    public static String getTempFile() {
        try {
            IPath path = TemporaryDirs.temp.newSubfolder();
            path = path.append("temp.pdm");
            return path.toOSString();
        }
        catch (ViperException viperException) {
            ViperExceptionHandler.logError("Can not create temp file");
            return null;
        }
    }

    public static String getRelativePath(String srcFile) {
        if (srcFile == null) {
            return null;
        }
        Path path = new Path(srcFile);
        int numberOfSegments = path.segmentCount();
        int i = 0;
        while (i < numberOfSegments) {
            String testSegment = path.segment(i);
            if (testSegment.compareTo(".") == 0) {
                return path.removeFirstSegments(i).toString();
            }
            ++i;
        }
        return path.lastSegment();
    }
}

