/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.render;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.birt.chart.computation.Engine3D;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.event.I3DRenderEvent;
import org.eclipse.birt.chart.event.IRenderInstruction;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.MarkerInstruction;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.TextRenderEvent;
import org.eclipse.birt.chart.event.WrappedInstruction;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;

public final class DeferredCache
implements Comparable<DeferredCache> {
    public static final int FLUSH_PLANE = 1;
    public static final int FLUSH_LINE = 2;
    public static final int FLUSH_MARKER = 4;
    public static final int FLUSH_LABLE = 8;
    public static final int FLUSH_3D = 16;
    public static final int FLUSH_PLANE_SHADOW = 32;
    public static final int FLUSH_CONNECTION_LINE = 64;
    public static final int FLUSH_ALL = 127;
    private final IDeviceRenderer idr;
    private final ArrayList<WrappedInstruction> alPlanes = new ArrayList(16);
    private Comparator<?> cpPlanes = null;
    private final ArrayList<LineRenderEvent> alLines = new ArrayList(16);
    private final ArrayList<LineRenderEvent> alConnectionLines = new ArrayList(16);
    private final ArrayList<MarkerInstruction> alMarkers = new ArrayList(16);
    private final ArrayList<TextRenderEvent> alLabels = new ArrayList(16);
    private final ArrayList<WrappedInstruction> alPlaneShadows = new ArrayList(4);
    private Comparator<?> cpPlaneShadows = null;
    public List<Object> al3D = new ArrayList<Object>(16);
    private final boolean bTransposed;
    private Chart cm;
    private DeferredCache parentDC = null;
    private static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.engine/factory");
    private boolean bAntialiasing = false;

    public DeferredCache(IDeviceRenderer idr, Chart c) {
        this.idr = idr;
        this.cm = c;
        this.bTransposed = c instanceof ChartWithAxes && ((ChartWithAxes)c).isTransposed();
    }

    public final Object addPlane(PrimitiveRenderEvent pre, int iInstruction) {
        return this.addPlane(pre, iInstruction, 0);
    }

    public final Object addPlane(PrimitiveRenderEvent pre, int iInstruction, int zorder_hint) {
        WrappedInstruction obj = null;
        try {
            WrappedInstruction wi;
            if (pre instanceof I3DRenderEvent) {
                wi = new WrappedInstruction(this, pre.copy(), iInstruction, (long)zorder_hint);
                this.al3D.add(wi);
            } else {
                wi = new WrappedInstruction(this, pre.copy(), iInstruction, (long)zorder_hint);
                this.alPlanes.add(wi);
            }
            obj = wi;
        }
        catch (ChartException ufex) {
            logger.log((Exception)((Object)ufex));
        }
        return obj;
    }

    public final void addPlaneShadow(PrimitiveRenderEvent pre, int iInstruction) {
        this.addPlaneShadow(pre, iInstruction, 0);
    }

    public final void addPlaneShadow(PrimitiveRenderEvent pre, int iInstruction, int zorder_hint) {
        try {
            if (pre instanceof I3DRenderEvent) {
                this.al3D.add(new WrappedInstruction(this, pre.copy(), iInstruction, (long)zorder_hint));
            } else {
                this.alPlaneShadows.add(new WrappedInstruction(this, pre.copy(), iInstruction, (long)zorder_hint));
            }
        }
        catch (ChartException ufex) {
            logger.log((Exception)((Object)ufex));
        }
    }

    public final void addModel(WrappedInstruction wi) {
        this.alPlanes.add(wi);
    }

    public final void addLine(LineRenderEvent lre) {
        if (lre instanceof I3DRenderEvent) {
            if (lre.getLineAttributes() != null && lre.getLineAttributes().isVisible()) {
                PrimitiveRenderEvent lre1 = lre.copy();
                this.al3D.add(lre1);
            }
        } else {
            this.alLines.add((LineRenderEvent)lre.copy());
        }
    }

    public final void addConnectionLine(LineRenderEvent lre) {
        this.alConnectionLines.add((LineRenderEvent)lre.copy());
    }

    public final void addLabel(TextRenderEvent tre) {
        if (tre instanceof I3DRenderEvent) {
            this.al3D.add(tre.copy());
        } else {
            this.alLabels.add((TextRenderEvent)tre.copy());
        }
    }

    public final void addMarker(PrimitiveRenderEvent pre, int iInstruction, double iMarkerSize, int zOrder) {
        try {
            if (pre instanceof I3DRenderEvent) {
                this.al3D.add(new MarkerInstruction(this, pre.copy(), iInstruction, iMarkerSize, zOrder));
            } else {
                this.alMarkers.add(new MarkerInstruction(this, pre.copy(), iInstruction, iMarkerSize, zOrder));
            }
        }
        catch (ChartException ufex) {
            logger.log((Exception)((Object)ufex));
        }
    }

    public final void flush() throws ChartException {
        this.flushOptions(127);
    }

    public final void flushOptions(int options) throws ChartException {
        if ((options & 0x20) == 32) {
            DeferredCache.flushPlaneShadows(this.idr, this.alPlaneShadows, this.cpPlaneShadows);
        }
        if ((options & 1) == 1) {
            DeferredCache.flushPlanes(this.idr, this.alPlanes, this.cpPlanes);
        }
        if ((options & 2) == 2) {
            DeferredCache.flushLines(this.idr, this.alLines);
        }
        if ((options & 0x40) == 64) {
            DeferredCache.flushLines(this.idr, this.alConnectionLines);
        }
        if ((options & 4) == 4) {
            DeferredCache.flushMarkers(this.idr, this.alMarkers);
        }
        if ((options & 8) == 8) {
            DeferredCache.flushLabels(this.idr, this.alLabels);
        }
        if ((options & 0x10) == 16) {
            DeferredCache.flush3D(this.idr, this.al3D);
        }
    }

    static void flush3D(IDeviceRenderer _idr, List alBlocks) throws ChartException {
        if (_idr == null || alBlocks == null) {
            return;
        }
        int i = 0;
        while (i < alBlocks.size()) {
            Object obj = alBlocks.get(i);
            if (obj instanceof IRenderInstruction) {
                WrappedInstruction wi = (WrappedInstruction)obj;
                if (wi.isModel()) {
                    List al = wi.getModel();
                    int j = 0;
                    while (j < al.size()) {
                        PrimitiveRenderEvent pre = (PrimitiveRenderEvent)al.get(j);
                        pre.fill(_idr);
                        pre.draw(_idr);
                        ++j;
                    }
                } else {
                    wi.getEvent().iObjIndex = i + 1;
                    switch (wi.getInstruction()) {
                        case 3: {
                            wi.getEvent().fill(_idr);
                            wi.getEvent().draw(_idr);
                            break;
                        }
                        case 2: {
                            wi.getEvent().fill(_idr);
                            break;
                        }
                        case 1: {
                            wi.getEvent().draw(_idr);
                        }
                    }
                }
                if (wi instanceof WrappedInstruction && wi.getSubDeferredCache() != null) {
                    wi.getSubDeferredCache().flushOptions(16);
                }
            } else if (obj instanceof LineRenderEvent) {
                ((LineRenderEvent)obj).draw(_idr);
            } else if (obj instanceof TextRenderEvent) {
                ((TextRenderEvent)obj).draw(_idr);
            }
            ++i;
        }
        alBlocks.clear();
    }

    static void flushLabels(IDeviceRenderer _idr, List labels) throws ChartException {
        if (_idr == null || labels == null) {
            return;
        }
        int i = 0;
        while (i < labels.size()) {
            TextRenderEvent tre = (TextRenderEvent)labels.get(i);
            tre.draw(_idr);
            ++i;
        }
        labels.clear();
    }

    static void flushMarkers(IDeviceRenderer _idr, List markers) throws ChartException {
        if (_idr == null || markers == null) {
            return;
        }
        Collections.sort(markers);
        int i = 0;
        while (i < markers.size()) {
            IRenderInstruction wi = (IRenderInstruction)markers.get(i);
            switch (wi.getInstruction()) {
                case 3: {
                    wi.getEvent().fill(_idr);
                    wi.getEvent().draw(_idr);
                    break;
                }
                case 2: {
                    wi.getEvent().fill(_idr);
                    break;
                }
                case 1: {
                    wi.getEvent().draw(_idr);
                }
            }
            ++i;
        }
        markers.clear();
    }

    static void flushLines(IDeviceRenderer _idr, List lines) throws ChartException {
        if (_idr == null || lines == null) {
            return;
        }
        int i = 0;
        while (i < lines.size()) {
            LineRenderEvent lre = (LineRenderEvent)lines.get(i);
            lre.draw(_idr);
            ++i;
        }
        lines.clear();
    }

    static void flushPlanes(IDeviceRenderer _idr, List planes, Comparator cp) throws ChartException {
        if (_idr == null || planes == null) {
            return;
        }
        if (cp != null) {
            Collections.sort(planes, cp);
        } else {
            Collections.sort(planes);
        }
        int i = 0;
        while (i < planes.size()) {
            IRenderInstruction wi = (IRenderInstruction)planes.get(i);
            if (wi.isModel()) {
                List al = wi.getModel();
                int j = 0;
                while (j < al.size()) {
                    PrimitiveRenderEvent pre = (PrimitiveRenderEvent)al.get(j);
                    pre.fill(_idr);
                    pre.draw(_idr);
                    ++j;
                }
            } else {
                wi.getEvent().iObjIndex = i + 1;
                switch (wi.getInstruction()) {
                    case 3: {
                        wi.getEvent().fill(_idr);
                        wi.getEvent().draw(_idr);
                        break;
                    }
                    case 2: {
                        wi.getEvent().fill(_idr);
                        break;
                    }
                    case 1: {
                        wi.getEvent().draw(_idr);
                    }
                }
            }
            ++i;
        }
        planes.clear();
    }

    static void flushPlaneShadows(IDeviceRenderer _idr, List planeShadows, Comparator cp) throws ChartException {
        if (_idr == null || planeShadows == null) {
            return;
        }
        if (cp != null) {
            Collections.sort(planeShadows, cp);
        } else {
            Collections.sort(planeShadows);
        }
        int i = 0;
        while (i < planeShadows.size()) {
            IRenderInstruction wi = (IRenderInstruction)planeShadows.get(i);
            if (wi.isModel()) {
                List al = wi.getModel();
                int j = 0;
                while (j < al.size()) {
                    PrimitiveRenderEvent pre = (PrimitiveRenderEvent)al.get(j);
                    pre.fill(_idr);
                    pre.draw(_idr);
                    ++j;
                }
            } else {
                wi.getEvent().iObjIndex = i + 1;
                switch (wi.getInstruction()) {
                    case 3: {
                        wi.getEvent().fill(_idr);
                        wi.getEvent().draw(_idr);
                        break;
                    }
                    case 2: {
                        wi.getEvent().fill(_idr);
                        break;
                    }
                    case 1: {
                        wi.getEvent().draw(_idr);
                    }
                }
            }
            ++i;
        }
        planeShadows.clear();
    }

    public void process3DEvent(Engine3D engine, double xOffset, double yOffset) {
        this.al3D = engine.processEvent(this.al3D, xOffset, yOffset, this.bAntialiasing);
    }

    public boolean isTransposed() {
        return this.bTransposed;
    }

    public List<LineRenderEvent> getAllConnectionLines() {
        return this.alConnectionLines;
    }

    public List<MarkerInstruction> getAllMarkers() {
        return this.alMarkers;
    }

    public List<TextRenderEvent> getAllLabels() {
        return this.alLabels;
    }

    public void setPlaneShadowsComparator(Comparator<?> cp) {
        this.cpPlaneShadows = cp;
    }

    public void setPlanesComparator(Comparator<?> cp) {
        this.cpPlanes = cp;
    }

    public DeferredCache deriveNewDeferredCache() {
        DeferredCache dc = new DeferredCache(this.idr, this.cm);
        dc.setParentDeferredCache(this);
        return dc;
    }

    public DeferredCache getParentDeferredCache() {
        return this.parentDC;
    }

    public void setParentDeferredCache(DeferredCache dc) {
        this.parentDC = dc;
    }

    public void setAntialiasing(boolean antialiasing) {
        this.bAntialiasing = antialiasing;
    }

    private int getMarkerZOrder() {
        if (this.getAllMarkers().size() > 0) {
            for (MarkerInstruction marker : this.getAllMarkers()) {
                if (marker == null) continue;
                return marker.getMarkerZOrder();
            }
        }
        return -1;
    }

    private int getConnectionLineZOrder() {
        if (this.getAllConnectionLines().size() > 0) {
            for (LineRenderEvent line : this.getAllConnectionLines()) {
                if (line == null) continue;
                return line.getZOrder();
            }
        }
        return -1;
    }

    private int getMarkerNLineZOrder() {
        int zOrder = this.getMarkerZOrder();
        if (zOrder >= 0) {
            return zOrder;
        }
        return this.getConnectionLineZOrder();
    }

    private double getMarkerSize() {
        if (this.getAllMarkers().size() > 0) {
            for (MarkerInstruction marker : this.getAllMarkers()) {
                if (marker == null) continue;
                return marker.getMarkerSize();
            }
        }
        return 0.0;
    }

    @Override
    public int compareTo(DeferredCache other) {
        if (this.getMarkerNLineZOrder() != other.getMarkerNLineZOrder()) {
            return this.getMarkerNLineZOrder() - other.getMarkerNLineZOrder();
        }
        if (other.getMarkerSize() - this.getMarkerSize() > 0.0) {
            return 1;
        }
        return -1;
    }
}

